	function PLOT_ATT_TG_Z(Att, Taug, wT, axis_Amax, axis_Tg_max)
 
	%	Plots the attenuation and group delay for a digital filter in a single plot
	%	The function may be modifes to fit different Examples.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2010-05-22
	% 	Modified by: 	LW 2010-11-16
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		Zoom does not work propely
	% 	Report bugs to:	Wanhammar@gmail.com

	%========================================================	
	% PowerPoint settings
	fs = 16; % Font size
	lw = 2; % Linewidth
	fn = 'times'; % Font
	%========================================================	
	subplot('position', [0.1 0.4 0.80 0.5]);
	[AX, H1, H2] = plotyy(wT, Att, wT, Taug);	
	axes(AX(1))
	axis([0 pi 0 axis_Amax]);
	set(AX(1),'XTick', []);
	set(AX(2),'XTick', []);
	set(H1, 'linewidth', lw);
	set(H2, 'linewidth', lw);
	set(AX(1), 'ylim', [0  axis_Amax]);
	set(AX(1), 'ytick', [0:10:axis_Amax])
	x = floor(min(Taug)); if x > 0, x = 0;end
	set(AX(2), 'ylim', [-20 axis_Tg_max]);
	set(AX(2), 'ytick', [-20:axis_Tg_max*20/axis_Amax:axis_Tg_max]);
	set(gca,'FontName', fn,'FontSize', fs);	
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName',fn,'FontSize',fs);
	axes(AX(2))
 
	set(gca,'FontName', fn,'FontSize', fs);	
	xlabel('{\it\omegaT}  [rad]','FontName', fn,'FontSize',fs);	
	ylabel('{\it\tau_g}({\ite^j^\omega^T})  [T]','FontName', fn,'FontSize',fs);
	axis([0 pi x axis_Tg_max]);	
	grid on;
	hold on
	AX = [0 0.1*pi 0.2*pi 0.3*pi 0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];
	lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	xtick(AX, lab);
	box on;	
	% Need to be changed to fit different Examples
	% EX 9.1
	%	text(0.2, -1,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(0.6, -15,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	% EX 9.2
	%	text(0.2, 12,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(0.6, -8,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	% EX 9.3
	%	text(0.2, 3.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(0.6, 0.95,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	% EX 8.4
	%	text(0.2, 16,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(1.1, 18,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
	% EX 9.5
	%	text(0.2, 10,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(1.5, 18,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);	
	%  EX 9.6
	%	text(0.2, 12,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(1.8, 20,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);	
	% EX 9.8
	%	text(0.5, 10,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(2.6, 24,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);	
	% EX 9.9
	%	text(0.5, 12,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(1.8, 20,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);		
	% EX 9.10
	%	text(1.5, 13,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(1.1, 34,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);	
	% EX 9.11
	%	text(0.7, 13,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(0.9, 4,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);	
	%  EX 9.16 and 8.17
	%	text(0.3, 3,'{\it\tau_g}({\ite^j^\omega^T })','FontName','times','FontSize',16);	
	%	text(1.1, 6,'{\itA}({\ite^j^\omega^T})','FontName','times','FontSize',16); 
	% EX 9.18
	%	text(0.3, -0.5,'{\it\tau_g}({\ite^j^\omega^T })','FontName','times','FontSize',16);
	%	text(1.1, 1,'{\itA}({\ite^j^\omega^T})','FontName','times','FontSize',16);
	% Ex 9.20
	%	text(0.3, 16,'{\it\tau_g}({\ite^j^\omega^T })','FontName','times','FontSize',16);	
	%	text(1.1, 13,'{\itA}({\ite^j^\omega^T})','FontName','times','FontSize',16);	
	% EX 9.21
	%	text(0.3, 9,'{\it\tau_g}({\ite^j^\omega^T })','FontName',fn,'FontSize',fs);	
	%	text(1.4, 9,'{\itA}({\ite^j^\omega^T})','FontName',fn,'FontSize',fs);
		
